<?LassoScript

	// This page allows the administrator to edit one page in the site including
	// the page's title and body.

	if: ($action >> 'update');

		// Update the page's record.

		// Store the page title, body, code, and status in variables.
		// The page id identifies which page will be updated.
		var: 'page_id' = (action_param: 'page_id');
		var: 'page_code' = (action_param: 'page_code');
		var: 'page_title' = (action_param: 'page_title');
		var: 'page_body' = (action_param: 'page_body');
		var: 'page_code' = (action_param: 'page_code');
		var: 'page_status' = ((action_param: 'page_status') >> 'N' ? 'N' | 'Y');
		var: 'page_section_id' = (action_param: 'page_section_id');

		// Create a page code and title if none was provided
		if: $page_code == '';
			var: 'page_code' = (string_replaceregexp: $page_title, -find='\\s+', -replace='_')->(substring: 0, 8);
		/if;
		if: $page_title == '';
			var: 'page_title' = 'Untitled Page';
		/if;
		
		// Check that the page code is unique
		inline: -log=$log_level,
				-search,
				-database='op_collaborate',
				-table='pages',
				-keyfield='id',
				-op='eq', 'code'=$page_code,
				-op='neq', 'id'=$page_id,
				-maxrecords=1, -uselimit,
				-returnfield='id';
			if: (found_count == 1);
				var: 'page_code' = '';
			/if;
		/inline;
		
		// Use a default page code if necessary
		if: $page_code == '';
			var: 'page_code' = lasso_uniqueid;
		/if;
		
		// Store the preferences in the preference map.  Any action parameters which start with
		// 'prefs_' are inserted into a map.  This map is then serialized into the database.
		
		var: 'prefs' = (map);
		iterate: action_params, (var: 'temp');
			var: 'key' = $temp->first;
			var: 'value' = $temp->second;
			if: $key->(beginswith: 'prefs_');
				$key -= 'prefs_';
				$prefs->(insert: $key = $value);
			/if;
		/iterate;
		
		// Update the record in the database.  Note that the 'prefs' field is set to a serialized
		// variable.  This allows the map to be stored in the table directly.
		
		if: $page_id != '';
			inline: -log=$log_level,
					-update,
					-database='op_collaborate',
					-table='pages',
					-keyfield='id',
					-keyvalue=(var: 'page_id'),
					'title'=(var: 'page_title'),
					'section_id'=(var: 'page_section_id'),
					'body'=(var: 'page_body'),
					'code'=(var: 'page_code'),
					'status'=(var: 'page_status'),
					'prefs'=$prefs->serialize;
				if: (error_msg == error_noerror);
					var: 'handled' = true;
					var: 'page' = (var: 'page_code');
				/if;
			/inline;
		/if;

	else: $action >> 'delete';

		// Delete the page from the site.

		var: 'page_id' = (action_param: 'page_id');

		if: $page_id != '';
			inline: -log=$log_level,
					-delete,
					-database='op_collaborate',
					-table='pages',
					-keyfield='id',
					-keyvalue=(var: 'page_id');
				if: (error_msg == error_noerror);
					var: 'page' = '';
					var: 'mode' = 'edit';
					var: 'handled' = false;		
				/if;
			/inline;
		/if;

	else: $action >> 'cancel';

		// Cancel the edit.  The user is returned to the section edit page.

		var: 'page' = '';
		var: 'mode' = 'edit';
		var: 'handled' = false;		

	/if;
	
	// Find the section name by looking up either the section_id or
	// code in the 'sections' table.  This is necessary in case the administrator
	// has moved a page from one section to another.
	
	if: ((var: 'page_section_id') != '');
		inline: -log=$log_level,
				-search,
				-database='op_collaborate',
				-table='sections',
				-keyfield='code',
				-op='eq', 'id'=(var: 'page_section_id'),
				-maxrecords=1, -uselimit,
				-returnfield='title', -returnfield='code';
			if: (found_count == 1);
				var: 'section_title' = (field: 'title');
				var: 'section' = (field: 'code');
			/if;
		/inline;
	else: ((var: 'section') != '');
		inline: -log=$log_level,
				-search,
				-database='op_collaborate',
				-table='sections',
				-keyfield='code',
				-op='eq', 'code'=(var: 'section'),
				-maxrecords=1, -uselimit,
				-returnfield='title';
			if: (found_count == 1);
				var: 'section_title' = (field: 'title');
			else;
				var: 'section' = '';
			/if;
		/inline;
	/if;

	// Load the preferences and values from the 'pages' record.  The 'prefs' variable
	// is created by deserialing the value in the 'prefs' field and then inserting each
	// of its values.
	
	if: ($page != '');
		inline: -log=$log_level,
				-search,
				-database='op_collaborate',
				-table='pages',
				-keyfield='id',
				-op='eq', 'code'=$page,
				-maxrecords=1, -uselimit;
			if: (found_count == 1);
				var: 'page_id' = (field: 'id');
				var: 'page_body' = (field: 'body');
				var: 'page_title' = (field: 'title');
				var: 'page_code' = (field: 'code');
				var: 'page_sort' = (field: 'sort');
				var: 'page_status' = (field: 'status');
				var: 'prefs' = (map);
				if: (field: 'prefs') >> '<map';
					var: 'temp' = null;
					$temp->(deserialize: (field: 'prefs'));
					$prefs->(insertfrom: $temp->iterator);
				/if;
				var: 'handled' = true;		
			else;
				var: 'handled' = false;
			/if;
		/inline;
	/if;


	// Define a set of helper tags.  Each tag outputs a checkbox with a clickable
	// label which allows a new color, font family, or font size to be chosen.  By
	// defining these custom tags the code for each of the checkboxes can be modified
	// in one place.
	
	var: 'stylePicker_id' = 0;
	define_tag: 'colorPicker', -required='name', -required='label', -optional='addl';
		$stylePicker_id++;
		local: 'output' = '<input type="checkbox" name="prefs_' + #name + '" id="stylePicker_' + $stylePicker_id + '" value="' + $prefs->(find: #name) + '"' + (($prefs->keys >> #name)?' checked="checked"') + ' /> <a href="" onclick="return stylePicker(this,\'stylePicker_' + $stylePicker_id + '\',\'Type a color name or hex value (e.g. #FFFFFF or white):\',\'color\',\'' + (local: 'addl') + '\');"' + (($prefs->keys >> #name)?' style="color: ' + $prefs->(find: #name) + ';"') + '>' + #label + '</a>';
		return: @#output;
	/define_tag;
	define_tag: 'fontPicker', -required='name', -required='label', -optional='addl';
		$stylePicker_id++;
		local: 'output' = '<input type="checkbox" name="prefs_' + #name + '" id="stylePicker_' + $stylePicker_id + '" value="' + $prefs->(find: #name) + '"' + (($prefs->keys >> #name)?' checked="checked"') + ' /> <a href="" onclick="return stylePicker(this,\'stylePicker_' + $stylePicker_id + '\',\'Type a font family name (e.g. Verdana or Arial):\',\'font-family\',\'' + (local: 'addl') + '\');"' + (($prefs->keys >> #name)?' style="font-family: ' + $prefs->(find: #name) + ';"') + '>' + (if_null: $prefs->(find: #name),#label) + '</a>';
		return: @#output;
	/define_tag;
	define_tag: 'fontSizer', -required='name', -required='label', -optional='addl';
		$stylePicker_id++;
		local: 'output' = '<input type="checkbox" name="prefs_' + #name + '" id="stylePicker_' + $stylePicker_id + '" value="' + $prefs->(find: #name) + '"' + (($prefs->keys >> #name)?' checked="checked"') + ' /> <a href="" onclick="return stylePicker(this,\'stylePicker_' + $stylePicker_id + '\',\'Type a font size (e.g. 12px or large):\',\'font-size\',\'' + (local: 'addl') + '\');"' + (($prefs->keys >> #name)?' style="font-size: ' + $prefs->(find: #name) + ';"') + '>' + (if_null: $prefs->(find: #name),#label) + '</a>';
		return: @#output;
	/define_tag;

	// The remainder of the page shows a form to the user which includes options
	// for the title, body, status, and code for the page and font style
	// preferences for the body.

?>

[if: $handled == true]

<h2>Collaborate</h2>
<div class="group_list" id="page_frame"[if: (var: 'ljax') == true] xmlns="http://www.w3.org/1999/xhtml"[/if]>
	<div class="group"><b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>
		<div class="group_title">
			<a href="index.lasso">Home</a> &gt; 
			<a href="edit.lasso?section=[encode_stricturl: $section]&amp;mode=edit" onclick="Lasso.includeTarget('page_frame', {args:this}); return false;">[var: 'section_title']</a> &gt; 
			[var: 'page_title']
		</div>
		<div class="wrap">
			<div class="nav">
				[include: 'edit/nav.lasso']
			</div>
			<form action="edit.lasso" method="post">
				<div class="page">
					<input type="hidden" name="mode" value="edit" />
					<input type="hidden" name="section" value="[var: 'section']" />
					<input type="hidden" name="page" value="[var: 'page']" />
					<input type="hidden" name="page_id" value="[var: 'page_id']" />
					<table>
						<tr>
							<th>Page Title</th>
							<td><input type="text" name="page_title" value="[var: 'page_title']" /></td>
						</tr>
						<tr>
							<th>Section</th>
							<td><select name="page_section_id">
								[inline: -log=$log_level,
										-search,
										-database='op_collaborate',
										-table='sections',
										-keyfield='id',
										-sortfield='sort']
									[records]
										<option value="[field: 'id']"[if: ((var: 'section') == (field: 'code')) || (((var: 'section') == '') && (loop_count == 1))] selected="selected"[/if]>[field: 'title']</option>
									[/records]
								[/inline]
							</select></td>
						</tr>
						<tr>
							<th>Page Code</th>
							<td><input type="text" name="page_code" value="[var: 'page_code']" /></td>
						</tr>
						<tr>
							<th>Page Status</th>
							<td><select name="page_status">
								<option value="Y"[if: (var: 'page_status') != 'N'] selected="selected"[/if]>Visible</option>
								<option value="N"[if: (var: 'page_status') == 'N'] selected="selected"[/if]>Hidden</option>
							</select></td>
						</tr>
						<tr>
							<th>Page Body</th>
							<td>
								<textarea name="page_body" cols="40" rows="8">[var: 'page_body']</textarea>
								<br />[colorPicker: 'page_color','Text Color']
								[fontPicker: 'page_fontfamily','Font Family']
								[fontSizer: 'page_fontsize','Font Size']
								<br /><input type="checkbox" name="prefs_page_fontweight" value="bold"[if: ($prefs->(find: 'page_fontweight') == 'bold')] checked="checked"[/if] /> <span style="font-weight: bold">Bold</span>
								<input type="checkbox" name="prefs_page_fontstyle" value="italic"[if: ($prefs->(find: 'page_fontstyle') == 'italic')] checked="checked"[/if] /> <span style="font-style: italic">Italic</span>
								<input type="checkbox" name="prefs_page_fontvariant" value="small-caps"[if: ($prefs->(find: 'page_fontvariant') == 'small-caps')] checked="checked"[/if] /> <span style="font-variant: small-caps">Small Caps</span>
								<br /><input type="radio" name="prefs_page_textalign" value="left"[if: ($prefs->(find: 'page_textalign') == 'left')] checked="checked"[/if] /> Left
								<input type="radio" name="prefs_page_textalign" value="center"[if: ($prefs->(find: 'page_textalign') == 'center')] checked="checked"[/if] /> Center
								<input type="radio" name="prefs_page_textalign" value="right"[if: ($prefs->(find: 'pagesection_footer_textalign') == 'right')] checked="checked"[/if] /> Right
							</td>
						</tr>
					</table>
					<p>
						<span style="float: right">
							<input type="submit" name="action" value="Delete Page" onclick="return confirm('This will delete the page permanently.');" />
						</span>
						<input type="submit" name="action" value="Update Page" />
						<input type="submit" name="action" value="Cancel" />
					</p>
				</div>
			</form>
			<!-- This div forces the background color to extend the length of the navigation -->
			<div style="clear: both;"><br /></div>
		</div>
	</div>
	<div class="group">
		<div class="group_title"><a href="index.lasso?section=[var: 'section']&amp;page=[var: 'page']">View This Page</a></div>
	</div>
</div>

[/if]
